# Ruby用語集 (Ruby 3.4 リファレンスマニュアル)

## 記号・数字

### %記法
「%」で始まる多種多様なリテラル記法の総称。

### 0 オリジン
番号が 0 から始まること。例えば、Array、Vector、Matrix などの要素番号、String における文字位置。

### 1 オリジン
番号が 1 から始まること。例えば、エラーメッセージの行番号、正規表現検索のキャプチャー番号。

## A - Z

### AWK
テキスト処理に適したプログラミング言語。Aho、Weinberger、Kernighan の頭文字から命名。

### Bignum
Ruby 2.3 までは大きな整数オブジェクトのクラス。Ruby 2.4 で Integer に統合されエイリアスとなった。

### bundled gem
標準添付ライブラリーの gem のうち、アンインストール可能なもの。

### Bundler
gem とバージョンを Gemfile で管理するツール。Ruby 2.6 で標準添付ライブラリーに追加。

### Coerce
異なるクラスの値同士の演算を実装する手法。数値クラス間の演算で活用される。

### CRuby
C で実装された Ruby 処理系。Matz Ruby、MRI とも呼ばれる。

### Crystal
Ruby に似た静的型付けプログラミング言語。

### CSI 方式
Code Set Independent。文字列がエンコーディング情報を持つ方式。Ruby 1.9 以降採用。

### default gem
標準添付ライブラリーの gem のうち、アンインストール不可のもの。

### dRuby
分散オブジェクトプログラミングの仕組み。異なるプロセス・マシン間でオブジェクトアクセスを可能にする。

### ENV
環境変数にアクセスするオブジェクト。Hash に似たインターフェース。

### eRuby
Ruby コードを埋め込めるテンプレートシステム。標準拡張子は .erb。

### FFI (Foreign function interface)
他言語関数インターフェース。言語間で関数呼び出しを実現する仕組み。

### Fixnum
Ruby 2.3 までの即値整数クラス。Ruby 2.4 で Integer に統合。

### flonum
浮動小数点数の即値実装版。演算が高速でメモリー効率的。

### GC
ガーベジコレクション。不要なオブジェクトのメモリー解放。

### gem
RubyGems でパッケージされたライブラリー。

### irb
組込み対話型 Ruby 実行環境。interactive Ruby から命名。

### is-a 関係
Object#is_a? で確認可能な関係。オブジェクトがクラス/モジュールに属すること。

### JRuby
Java で実装された Ruby 処理系。Ruby と Java の連携が容易。

### Matz
Ruby 作者、まつもとゆきひろ氏。

### mruby
組込み向け Ruby 仕様および処理系。

### nil
NilClass の唯一のインスタンス。論理値としては偽。

### Opal
Ruby コードを JavaScript に変換するソフトウェア。

### Rake
Ruby 標準添付ビルドツール。Rakefile でタスクを記述。

### refinement
既存クラス/モジュールを特定スコープのみで改変する仕組み。

### RubyGems
gem 管理ライブラリーおよびツール。Ruby 1.9 で取り込まれた。

### Rubyist
Ruby 使用者。

### self
現在コンテキストの暗黙レシーバー。擬似変数。

## あ行

### アクセッサー
インスタンス変数の読み出し/設定メソッドの総称。

### 浅い複製
dup メソッドで複製時、要素オブジェクトは複製されない。

### アリティー
メソッド/Proc の引数/パラメーター数。

### 安全参照演算子
&. 演算子。nil のときメソッド呼び出しせず nil 返却。Ruby 2.3 導入。

### 安定ソート
同順位要素の順序がソート前後で保たれるソート。

### 委譲
オブジェクトメソッド処理を他オブジェクトに委ねること。

### イテレーター
繰り返し処理のブロック付きメソッド。

### インスタンス
クラスに属すオブジェクト。

### インスタンス変数
オブジェクト固有の @ で始まる変数。

### インスタンスメソッド
クラス/モジュール定義のインスタンスレシーバーメソッド。

### 宇宙船演算子
<=> 演算子の俗称。順序関係を表現。

### 埋め込みドキュメント
=begin から =end までのコメント。

### エイリアス
別名。

### エンコーディング
文字列のバイト列表現方法。UTF-8、Shift_JIS など。

### 演算子
項と共に式を構成する構文要素。

### 鬼雲
Ruby 2.0 以降採用の正規表現エンジン。鬼車フォーク。

### 鬼車
Ruby 1.9.x 採用の正規表現エンジン。

### オーバーライド
上位クラス/モジュールメソッド再定義。super で元メソッド呼び出し可。

### オブジェクト
Ruby ではすべてのデータ。クラスに属しメソッド呼び出しに反応。

### オブジェクト ID
オブジェクト一意特定整数。Object#object_id で取得。

### オブジェクト空間
オブジェクト漂う仮想空間。ObjectSpace クラスで情報取得。

### オープンクラス
組込みクラス再定義可能性。String、Integer など改変可。

### オペランド
演算子式で演算対象の式。被演算子。

### 親クラス
スーパークラス。

## か行

### 下位クラス
サブクラス。

### 返り値
メソッド呼び出し側に返すオブジェクト。戻り値。

### 可視性（メソッドの）
public、private、protected 三種類の呼び出し可能性。

### 型
データ型。

### ガーベジコレクション
不要オブジェクトメモリー解放。GC。

### 可変長引数
メソッド実引数数固定でないこと。

### 空
要素無い状態。empty? メソッド確認。

### 仮引数
メソッド定義で実引数受け取る変数。

### 環境変数
OS がプロセスに提供する文字列データ。

### キーワード引数
キーワードで特定される引数。

### 組み込みクラス
Array、String など処理系組込みクラス。

### 組み込みライブラリー
Ruby 本体組込みライブラリー。require 不要。

### クラス
オブジェクト生成し振る舞い規定するもの。Class クラスのオブジェクト。

### クラスインスタンス変数
クラスのインスタンス変数。クラス変数と異なる。

### クラス変数
@@ で始まる名前の共有変数。サブクラス/モジュール共有。

### クラス名
クラス定義で同名定数定義される。

### クラスメソッド
クラス特異メソッド。

### グローバル変数
グローバルスコープの $ で始まる変数。

### 継承
下位クラスにスーパークラス機能受け継がれること。単一継承。

### ゲッター
インスタンス変数値取り出しメソッド。

### 子クラス
サブクラス。

### コレクション
配列、ハッシュ、Set など要素集まりオブジェクト。コンテナー。

### コロン記法（ハッシュの）
ハッシュ式でシンボルキー key: value 形式記法。

## さ行

### 再定義
既定義メソッド改めて定義。

### サブクラス
クラス A から継承新規クラス B。子/下位/派生クラス。

### 式展開
文字列リテラルに式埋め込まれ評価値文字列化埋め込み。

### 識別子
変数・定数・メソッド・クラス・モジュール等名前。

### 自己代入
他値演算結果代入。a += 1 のような += 形式。

### 実引数
メソッド呼び出しで与えられる値。

### 述語メソッド
返り値真偽値用メソッド。末尾に ? 習慣。

### 上位クラス
スーパークラス。

### 条件演算子
三項演算子。条件式 ? 真式 : 偽式 形式。

### 条件式
真偽値用いる式。if、unless、while、until 後に。

### 初期化
オブジェクト生成時 initialize メソッド呼び出し処理。

### 処理系
言語プログラム読込・解釈・実行するプログラム。

### 真偽値
Ruby では nil と false だけが偽。他は真。

### シンタックスシュガー
同じ意味をより分かりやすい別構文で記述可能にしたもの。

### シンボル
文字列と一対一対応、処理系内部整数管理オブジェクト。イミュータブル。

### 数値オブジェクト
Numeric クラスサブクラスのインスタンス。

### スクリプト
軽量言語プログラム。

### スクリプト言語
テキスト処理念頭に作られたプログラミング言語。Ruby はこの系統。

### スクリプトエンコーディング
スクリプトファイル自体のエンコーディング。

### スコープ
変数・定数・メソッド参照可能コード範囲。

### スタックトレース
プログラム実行時点メソッド呼び出し元情報遡るデータ。バックトレース。

### スーパークラス
クラス B がクラス A サブクラスのとき A。親/上位クラス。

### スレッド
並行実行制御流れ。スレッド間でメモリー共有。

### スレッドセーフ
複数スレッド並行実行でも問題無いこと。

### 正規表現
文字列パターン表現言語。Regexp クラス。

### 整数
Integer クラスのインスタンス。

### セッター
インスタンス変数値代入メソッド。= 末尾習慣。

### 即値
オブジェクト値そのものビット列表現。CRuby では nil、true、false ほか。

## た行

### 大域脱出
例外発生もしくは throw によって実行中断。制御階層全抜け。

### 代入
変数にオブジェクト割り当て。

### 代入演算子
= は代入演算子。代入も式で評価値は代入値。

### 多重継承
複数クラス下位クラス。Ruby では禁止、mix-in 使用。

### 単項演算子
単一項に働く演算子。+ - ! not 等。

### 短絡評価
論理式評価で最小限項評価。and、or は短絡。

### 抽象クラス
直接インスタンス持たない念頭クラス。Numeric がその例。

### 定数
クラス/モジュール属する再代入警告出るもの。

### テスト駆動開発
テストコード先記述後機能実装手法。TDD。

### データ型
データ種類。整数/文字列/配列型等。Ruby では型制限なし。

### 同一性
オブジェクト ID 一致による同じオブジェクト性。equal? で判定。

### 同値性
== で判定される何らか同じありさま。

### 特異クラス
オブジェクト固有クラス。singleton_class で取得。

### 特異メソッド
オブジェクト固有メソッド。特異クラスのインスタンスメソッド。

### トップレベル
スクリプト最外側コンテキスト。main が self。

## な行

### 名前空間
メソッド・定数名衝突避ける仕組み。クラス/モジュール作成。

### 名前重要
命名機会多い。機能ふさわしい名前付け重視。Matz 座右の銘。

### ヌル文字
制御文字。Ruby ではファイルパス使用不可。

### ネスト
制御構造・ブロック・定義の入れ子。

## は行

### 破壊的
レシーバーに影響与えるメソッド。オブジェクト自身変更。

### 派生クラス
サブクラス。

### バックトレース
スタックトレース。

### ハッシュ
キーに値対応させたコレクション。連想配列、辞書。Ruby は順序保存。

### ハッシュ値
オブジェクトからハッシュ関数で作られた小データ。Object#hash で取得。

### 番号指定ブロックパラメーター
Ruby 2.7 導入。_1、_2 で引数参照。宣言不要。

### ヒアドキュメント
文字列リテラル。<<識別子 式含む行次行から識別子行直前までの文字列。

### 評価
式値実際求めること。ブロック実行も評価。

### 標準添付ライブラリー
Ruby 本体配布ライブラリー。インストール不要。gem 形式あり。

### ファイバー
Fiber オブジェクト表す軽量スレッド。

### 深い複製
コンテナーオブジェクト複製で要素も再帰的複製。deep copy。

### 浮動小数点数
符号・仮数部・指数部で実数表現。Float、BigDecimal クラス。

### ブレークポイント
デバッガー実行一時停止設定地点。

### ブロック
メソッド与えられるコード塊。一つのみ。Proc オブジェクト化可。

### ブロック付きメソッド呼び出し
実引数外にブロック与えてメソッド呼び出し。

### ブロックパラメーター
ブロック仮引数。| | 内記述。

### ブロック引数
メソッド & 付き仮引数。Proc オブジェクト受け取り。

### ブロックローカル変数
| | 内セミコロン後識別子宣言変数。ブロック内スコープ。

### 別名
メソッド・グローバル変数別名。alias で定義。

### 変数
オブジェクト紐付け名札。

### ぼっち演算子
安全参照演算子。

### ポリモルフィズム
同名メソッド呼び出しでレシーバークラスにより異なる実行。多態、多相性。

## ま行

### マジックコメント
スクリプト先頭記述 Ruby 処理系への指示。

### ミックスイン
モジュール・クラスに他モジュール機能組込。include。

### 未定義化（メソッドの）
メソッド定義取り消し。undef 式、Module#undef_method。

### メソッド
クラス・モジュール定義名前持つもの。

### メソッドシグネチャ
メソッド名・取り得る引数情報。

### メソッド探索
オブジェクトメソッド呼び出し時メソッド定義探索。

### メソッド・チェーン
メソッド返り値対しメソッド呼び出しつなげ。

### メタプログラミング
実行中クラス・メソッド作成・変更プログラミング手法。

### 文字コード
文字集合各要素に番号・ビット列割振体系。

### モジュール
大まかにはクラスからインスタンス生成機能省いたもの。

### モジュール関数
モジュールインスタンスメソッド・特異メソッド二重定義。

### 文字列
String クラスのインスタンス。自身エンコーディング認識。

### 戻り値
返り値。

## や行

### 優先順位（演算子の）
演算子結合順位。

### 有理数
整数分の整数形分数表現数。Rational クラスのインスタンス。

### ユニットテスト
メソッド等小単位ソフトウェアテスト。単体テスト。

### 予約語
構文特別意味持つため名前自由使用不可文字列。if、do、begin、end、nil 等。

## ら行

### ラッパーライブラリー
C 言語等ライブラリー Ruby 使用可能にした拡張ライブラリー。

### リスコフの置換原則
下位クラスインスタンスは上位クラスインスタンス性質すべて持つべき。

### リテラル
プログラム中直接記述値。3.14、"foo"、/\d+/。

### リフレクション
実行中プログラム情報取得・変更。メタプログラミング。

### 例外
Exception クラス、その子孫クラスのインスタンス。

### レキシカルスコープ
ソースコード見た目で決まるスコープ。静的スコープ。

### レシーバー
メソッド呼び出しの特定オブジェクト。

### 連想配列
ハッシュ。

### ローカル変数
ローカルスコープ持つ変数。

### ロケット演算子
=> 演算子の俗称。ハッシュ式キー値つなぎ、rescue 例外捉え使用。

### ロードパス
require、load でファイル探索場所。$LOAD_PATH で参照・変更。

## わ行

### ワンライナー
コマンドライン上プログラム一行表現。ruby -e オプション使用。
