# Marshal フォーマット (Ruby 3.4)

## 概要

Ruby の Marshal モジュールは、オブジェクトをシリアル化するための形式を定義しています。このドキュメントはフォーマットバージョン 4.8 に基づいています。

## 基本型

### nil, true, false

これらは単一文字で表現されます：
- `nil` → `'0'`
- `true` → `'T'`
- `false` → `'F'`

## 数値型

### Fixnum

`'i'` で始まり、2つの形式で数値を表現します。

**形式 1（単一バイト）**
- `n == 0` → `0`
- `0 < n < 123` → `n + 5`
- `-124 < n < 0` → `n - 5`

**形式 2（複数バイト）**

範囲外の数値には「メタバイト」+「データバイト」形式を使用。メタバイトの値は -4 から -1、または 1 から 4 の範囲です。

### Float

`'f'` で始まるデータ構造。値は「%.16g」形式の文字列で保存されます。特殊値（nan、inf、-inf）にも対応しています。

### Bignum

`'l'` で始まるデータ構造。符号（`'+'` または `'-'`）と short 値の列で表現されます。

## 文字列と正規表現

### String

`'"'` で始まります。形式は「長さ + 文字列データ」。Ruby 1.9 以降では「エンコーディング情報」も含まれます。

### Regexp

`'/'` で始まります。「長さ + ソース + オプション」で構成。オプションには `Regexp#options` の結果と漢字コードフラグが含まれます。

## コレクション型

### Array

`'['` で始まり、「要素数 + 各要素の dump」の形式です。

### Hash

3つのバリエーションがあります：

- **通常** → `'{'`：要素のキーと値
- **デフォルト値付き** → `'}'`：キー値ペアの後にデフォルト値
- **default_proc付き** → dump 不可（TypeError が発生）

### Struct

`'S'` で始まり、「クラス名 + メンバ数 + 各メンバ（名前と値）」で表現されます。

## オブジェクト参照

### Symbol

`':'` で始まる新規シンボルと、`';'` で既出シンボルへの参照があります。参照は内部ハッシュテーブルのレコード位置を示します。

### Object Link

`'@'` で既出オブジェクトへの参照を表現します。循環参照にも対応しています。

## クラス・モジュール

### Class/Module（新形式）

`'c'`（クラス）または `'m'`（モジュール）で始まります。「クラス名の長さ + クラス名」で構成。

**注記**：「インスタンス変数やクラス変数は dump されません」

## インスタンス変数

### 'I' 形式

String や Array などのサブクラスで、「オブジェクト dump + 変数数 + 変数名と値のペア」として表現されます。

### 'o' 形式（Object）

通常のオブジェクトは `'o'` で始まり、「クラス名 + 変数数 + 各変数」を含みます。

## カスタムシリアライゼーション

### 'u' 形式（`_dump`/`_load`）

ユーザー定義の `_dump` メソッドがある場合に使用。インスタンス変数は含まれません。

### 'U' 形式（`marshal_dump`/`marshal_load`）

`marshal_dump` の戻り値をそのまま保存します。インスタンス変数は含まれません。

---

**ライセンス**：[Creative Commons Attribution 3.0](https://creativecommons.org/licenses/by/3.0/)
