# pack テンプレート文字列

## 概要

Ruby の `Array#pack`、`String#unpack`、`String#unpack1` メソッドで使用するテンプレート文字の完全なリファレンスです。

テンプレート文字は後に数字で長さを指定でき、`*` で残り全てを表せます。連続するテンプレート文字は短縮記法で表記可能です（例：`"iiii"` → `"i4"`）。

テンプレート文字列内の空白やコメント（`#` から改行まで）は無視されます。

## 整数型のシステム依存性

| 用途 | テンプレート文字 | 説明 |
|------|-----------------|------|
| ネットワークプロトコル向け | n, N, v, V | エンディアン非依存、整数サイズ非依存 |
| C構造体向け | s!, S!, i!, I!, l!, L!, q!, Q!, j!, J! | エンディアン依存、サイズ依存 |
| stdint.h互換 | s, S, l, L, q, Q | エンディアン依存、サイズ非依存 |
| バイナリ解析向け | S>, s>, s!>, l<, l!< | エンディアン強制指定 |

## テンプレート文字一覧

### 文字列型

| 文字 | 説明 | pack動作 | unpack動作 |
|------|------|---------|----------|
| **a** | ASCII文字列 | ヌル文字を詰める | ヌル文字やスペースを残す |
| **A** | ASCII文字列 | スペースを詰める | ヌル文字やスペースを削除 |
| **Z** | ヌル終端文字列 | ヌル文字を詰める | ヌル文字を削除 |

### ビット/16進文字列

| 文字 | 説明 |
|------|------|
| **b** | ビットストリング（下位ビット優先） |
| **B** | ビットストリング（上位ビット優先） |
| **h** | 16進文字列（下位ニブル優先） |
| **H** | 16進文字列（上位ニブル優先） |

### 整数型

| 文字 | 説明 | サイズ |
|------|------|--------|
| **c** | 符号付きchar | 8bit |
| **C** | 符号なしchar | 8bit |
| **s** | 符号付きshort | 16bit |
| **S** | 符号なしshort | 16bit |
| **i** | 符号付きint | システム依存 |
| **I** | 符号なしint | システム依存 |
| **l** | 符号付きlong | 32bit |
| **L** | 符号なしlong | 32bit |
| **q** | 符号付きlonglong | 64bit |
| **Q** | 符号なしlonglong | 64bit |

### ネットワーク/エンディアン指定

| 文字 | 説明 |
|------|------|
| **n** | ビッグエンディアン unsigned 16bit |
| **N** | ビッグエンディアン unsigned 32bit |
| **v** | リトルエンディアン unsigned 16bit |
| **V** | リトルエンディアン unsigned 32bit |

### 浮動小数点数

| 文字 | 説明 |
|------|------|
| **f** | 単精度浮動小数点数 |
| **d** | 倍精度浮動小数点数 |
| **e** | リトルエンディアン単精度 |
| **E** | リトルエンディアン倍精度 |
| **g** | ビッグエンディアン単精度 |
| **G** | ビッグエンディアン倍精度 |

### エンコーディング

| 文字 | 説明 |
|------|------|
| **m** | Base64エンコード |
| **m0** | Base64エンコード（RFC4648準拠） |
| **M** | quoted-printable |
| **u** | uuencode |
| **U** | UTF-8 |
| **w** | BER圧縮整数 |

### ポインタ/位置制御

| 文字 | 説明 |
|------|------|
| **p** | ヌル終端文字列へのポインタ |
| **P** | 構造体へのポインタ |
| **x** | ヌルバイト(pack) / バイト読み飛ばし(unpack) |
| **X** | 1バイト後退 |
| **@** | 絶対位置へ移動 |
| **j** | intptr_t（符号付き） |
| **J** | uintptr_t（符号なし） |

## 使用例

```ruby
# 数値配列を文字列に変換
[82, 117, 98, 121].pack("c*")  # => "Ruby"

# 文字列を数値配列に変換
"Ruby".unpack('C*')    # => [82, 117, 98, 121]

# ヌルバイトの挿入
[82, 117, 98, 121].pack("ccxxcc")  # => "Ru\x00\x00by"

# ネットワークバイトオーダー
[1,2].pack("n2")  # => "\x00\x01\x00\x02"

# Base64エンコード
["Hello"].pack("m")  # => "SGVsbG8=\n"
```

---

このドキュメントはRuby 3.4のリファレンスマニュアルです。
