# sprintf フォーマット

## 概要

Ruby の sprintf フォーマットは基本的に C 言語の sprintf に準じていますが、いくつかの違いがあります。2進数指示子(%b, %B)が存在し、C 特有の型修飾子がないなどの特徴があります。

## 基本構文

```
%[nth$][フラグ][幅][.精度]指示子
%[<name>][フラグ][幅][.精度]指示子
```

パーセント記号自体を出力するには `%%` と記述します。

## フラグ

| フラグ | 説明 |
|--------|------|
| `#` | 2進、8進、16進でプレフィックス("0b", "0B", "0", "0x", "0X")を付加 |
| `+` | 出力を符号付きにし、正の数に"+"を付加 |
| ` ` (スペース) | 正の数に空白を付加 |
| `-` | 出力を左詰めにする |
| `0` | 右詰めで0を詰める |

### フラグの使用例

```ruby
p sprintf("%#b", 10)    #=> "0b1010"
p sprintf("%+d", 1)     #=> "+1"
p sprintf("% d", 1)     #=> " 1"
p sprintf("%010d", 10)  #=> "0000000010"
```

## 幅

0 以外の数字で始まる数字列が幅指定になります。生成文字列の最小限の幅を示します。

```ruby
p sprintf("%+5d", 11)   #=> "  +11"
p sprintf("%+05d", 11)  #=> "+0011"
p sprintf("%#0*x", 5, 10) #=> "0x00a"
```

## 精度

"." の後の数字列が精度を表します。

**整数指示子の場合**: 数値列部分の長さ
```ruby
p sprintf("%10.5d", 1)  #=> "     00001"
```

**浮動小数点数(f)の場合**: 小数部の桁数
```ruby
p sprintf("%10.5f", 1)  #=> "   1.00000"
```

**文字列指示子(s, p)の場合**: 切り詰める文字数
```ruby
p sprintf("%10.2s", "foo") #=> "        fo"
```

## 指示子

### 文字列指示子

**c**: 数値(0-255)を文字コードに変換
```ruby
p sprintf("%c", 97) #=> "a"
```

**s**: 文字列を出力
```ruby
p sprintf("%s", "test") #=> "test"
```

**p**: Object#inspect の結果を出力
```ruby
p sprintf("%p", /e+/) #=> "/e+/"
```

### 整数指示子

**d, i**: 10進整数
```ruby
p sprintf("%d", -1) #=> "-1"
```

**u**: 符号なし10進整数
```ruby
p sprintf("%u", -1) #=> "-1"
```

**b, B**: 2進数(大文字/小文字)
```ruby
p sprintf("%#b", 10) #=> "0b1010"
```

**o**: 8進数
```ruby
p sprintf("%#o", 10) #=> "012"
```

**x, X**: 16進数(大文字/小文字)
```ruby
p sprintf("%#x", 10) #=> "0xa"
```

### 浮動小数点数指示子

**f**: 小数点表現
```ruby
p sprintf("%f", 1.0) #=> "1.000000"
```

**e, E**: 指数表現
```ruby
p sprintf("%e", 1.0) #=> "1.000000e+00"
```

**g, G**: 条件に応じて e または f の形式
```ruby
p sprintf("%g", 1.0) #=> "1"
```

**a, A**: 16進指数表現
```ruby
p sprintf("%a", 729.0/10) #=> "0x1.239999999999ap+6"
```

## 引数指定

### nth$ による位置指定

n 番目の引数を参照します。

```ruby
p sprintf("%3$d, %2$x, %1$o", 1, 2, 3) #=> "3, 2, 1"
p sprintf("%1$d, %1$x, %1$o", 10) #=> "10, a, 12"
```

### %<name> によるハッシュキー参照

Symbol キーを持つハッシュの値をフォーマットして参照します。

```ruby
p sprintf('%<foo>f : %<bar>+d', foo: 1, bar: 2) #=> "1.000000 : +2"
```

### %{name} によるハッシュキー参照（フォーマットなし）

```ruby
p sprintf('%{foo}f : %{bar}+d', foo: 1, bar: 2) #=> "1f : 2+d"
```
