# Rubyで使われる記号の意味

## 概要

このページはRubyプログラミングで使用される様々な記号と演算子について解説しています（正規表現の複雑な記号は除く）。

## 主要な記号と用途

### ! 感嘆符
- **否定演算子**: `!true` で論理的な反転を実行
- **比較演算**: `3 != 5` は「等しくない」を表す
- **メソッド名**: 破壊的なメソッドを示す慣例（例：`tr!`）
- **正規表現**: `!~` でマッチ失敗時に真を返す

### ? 疑問符
- **文字列リテラル**: `?a` は長さ1の文字列を作成
- **メソッド名**: 真偽値を返すメソッドの慣例
- **条件演算子**: `xx ? yy : zz` は三項演算子として機能

### # ハッシュ
- **コメント**: 行末までコメント化
- **式展開**: `"a is #{a}"` で変数展開
- **マジックコメント**: `# coding: utf-8`

### % パーセント
- **演算子**: `10 % 3` で剰余計算
- **フォーマット指定**: `"%04b" % 10`
- **リテラル記法**: `%w[foo bar baz]` で配列作成

### & アンパサンド
- **論理積**: `3 & 5` でビット演算
- **ブロック引数**: `def xxx(&yyy)`
- **安全なナビゲーション**: `xxx&.yyy` でnilチェック付きメソッド呼び出し

### | パイプ
- **論理和**: `3 | 5` でビット演算
- **ブロックパラメータ**: `{|n| p n}`

### 比較演算子
| 記号 | 用途 |
|------|------|
| `<` | より小さい |
| `<=` | 以下 |
| `>` | より大きい |
| `>=` | 以上 |
| `<=>` | スペースシップ演算子 |

### : コロン
- **シンボル**: `:exit` はシンボルリテラル
- **スコープ演算子**: `Net::HTTP` で定数参照
- **ハッシュ記法**: `{ a: "aaa" }` は新しい記法

### . ドット
- **メソッド呼び出し**: `xxx.yyy`
- **範囲演算子**: `1..20`（最大値を含む）、`1...20`（含まない）

### * アスタリスク
- **乗算**: `2 * 3`
- **累乗**: `2 ** 3`
- **引数展開**: `def xxx(*yy)`
- **多重代入**: `x, *y = foo()`

### = イコール
- **代入**: `a = 12`
- **等号比較**: `a == 12`
- **特殊な等号**: `a === 12` はcase文で使用

### ~ チルダ
- **ビット否定**: `~3` でビット反転
- **正規表現マッチ**: `/xxx/ =~ yyy`

### $ ドルマーク
- **グローバル変数**: `$xxx`
- **特殊変数**: `$_`、`$!` など
- **行末**: 正規表現内で `/xx$/`

### @ アットマーク
- **インスタンス変数**: `@xxx`
- **クラス変数**: `@@xxx`

### _ アンダースコア
- **識別子内での使用**: `xxx_yyy`
- **数値リテラル**: `123_456` で桁数を明確化
- **番号指定パラメータ**: `_1`～`_9` でブロック引数参照

### {} ブレース
- **ハッシュリテラル**: `{ 1 => "11" }`
- **ブロック**: `5.times{|n| p n}`
- **式展開**: `"a is #{a}"`

### [] 角括弧
- **配列リテラル**: `[1, "some", :ok]`
- **[] メソッド**: `'abcde'[1,2]`
- **文字クラス**: 正規表現内での `[abc]`

### () 丸括弧
- **グループ化**: `(true and false)`
- **メソッド引数**: 省略可能

### クォート類
- **ダブルクォート**: `"abc"` で式展開可能
- **シングルクォート**: `'abc'` で最小限のエスケープ
- **バッククォート**: `` `ls` `` でコマンド実行

### \ バックスラッシュ
- **エスケープ**: 文字列や正規表現内
- **継続行**: 改行前に配置で次行と接続

### ; セミコロン
- **式の区切り**: 改行と同等
- **ブロックローカル変数**: `{|v; z|` で変数宣言

---

*このリファレンスマニュアルはRuby公式ドキュメントに基づいています。*
