# Ruby 3.4 リファレンスマニュアル - C API 関数一覧

## 概要

このページは、Ruby 3.4リファレンスマニュアルの関数一覧ページです。Ruby インタプリタのC APIに関する関数群を網羅的に記載しています。

## 主要なセクション

### メモリ管理機能

- **ALLOC / ALLOC_N / ALLOCA_N**: メモリ割り当て関連の機能。ALLOC_Nは「type型のメモリをn個割り当てる」など、異なるサイズ指定に対応しています。

- **Data_Make_Struct / Data_Wrap_Struct**: 構造体をRubyオブジェクトでラップするための関数群

### オブジェクト操作

- **rb_obj_** プレフィックス: オブジェクトの操作全般（クローン、ダプリケーション、フリーズなど）
- **rb_class_** プレフィックス: クラス操作関連の機能
- **rb_mod_** プレフィックス: モジュール操作関連の機能

### 型変換

- **FIX2INT / FIX2LONG**: Fixnumから整数型への変換
- **INT2FIX / INT2NUM**: 整数からFixnum/Bignumへの変換
- **rb_String / rb_Array / rb_Integer**: 各種型への変換関数

### 評価・実行制御

- **rb_eval_string**: 文字列をRubyプログラムとしてコンパイル・評価
- **rb_funcall**: メソッド呼び出し
- **rb_yield**: ブロック実行
- **rb_protect / rb_rescue / rb_ensure**: 例外処理メカニズム

### スレッド管理

- **rb_thread_** プレフィックス: スレッド生成、切り替え、同期処理など多数の関数

### ガベージコレクション

- **rb_gc_mark / rb_gc_mark_children**: GCマーキング処理
- **rb_gc_disable / rb_gc_enable**: GC制御

### メソッド定義

- **rb_define_method**: インスタンスメソッド定義
- **rb_define_singleton_method**: 特異メソッド定義
- **rb_define_module_function**: モジュール関数定義

## 関数設計の特徴

このAPIは「type型のメモリをn個割り当てる」といった明確な役割分担と、一貫性のある命名規則を採用しており、Cレベルでの細粒度な制御を提供しています。

---

*このドキュメントは[Creative Commons License](https://creativecommons.org/licenses/by/3.0/)の下で提供されています。*
