# Ruby 3.4 リファレンスマニュアル

オブジェクト指向スクリプト言語 Ruby の公式リファレンス資料です。

## 基本情報

- 対応バージョン：Ruby 3.4
- 原著：まつもとゆきひろ
- 公式サイト：[Ruby オフィシャルサイト](https://www.ruby-lang.org/ja/)
- [最新版URL](https://www.ruby-lang.org/ja/documentation/)

## 注記

組み込みクラスのリファレンスはほぼ完備。標準添付ライブラリは一部未完成。その他ドキュメントについては継続的な改善が進行中です。

---

## 言語仕様

- [はじめに](spec/intro.md)
- [コマンド](spec/commands.md)
- [Rubyの起動](spec/rubycmd.md)
- [環境変数](spec/envvars.md)
- [オブジェクト](spec/object.md)
- [クラス](spec/class.md)
- [Ruby プログラムの実行](spec/eval.md)
- [終了処理](spec/terminate.md)
- [スレッド](spec/thread.md)
- [字句構造](spec/lexical.md)
- [プログラム・文・式](spec/program.md)
- [変数と定数](spec/variables.md)
- [リテラル](spec/literal.md)
- [演算子式](spec/operator.md)
- [制御構造](spec/control.md)
- [メソッド呼び出し(super・ブロック付き・yield)](spec/call.md)
- [クラス／メソッドの定義](spec/def.md)
- [パターンマッチ](spec/pattern_matching.md)
- [多言語化](spec/m17n.md)
- [正規表現](spec/regexp.md)
- [手続きオブジェクトの挙動の詳細](spec/lambda_proc.md)

## リファレンス

- [Builtin libraries](library/builtin.md)
- [All libraries](library/index.md)
- [All C API](function/index.md)

## その他

- [Ruby変更履歴](doc/news_index.md)
- [pack テンプレート文字列](doc/pack_template.md)
- [sprintf フォーマット](doc/print_format.md)
- [Ruby用語集](doc/glossary.md)
- [Rubyで使われる記号の意味](doc/symref.md)
- [Marshal フォーマット](doc/marshal_format.md)
- [配布条件](doc/license.md)
- [このマニュアルのヘルプ](doc/help.md)

---

ライセンス: [Creative Commons License](https://creativecommons.org/licenses/by/3.0/)

- [フィードバックを送る](https://github.com/rurema/doctree/issues/new)
- [このマニュアルを編集する](https://github.com/rurema/doctree/edit/master/refm/doc/index.rd#L1)
