# Ruby 3.4 組み込みライブラリ リファレンス

## 概要

組み込みライブラリは Ruby 本体に組み込まれているライブラリです。"require を書かなくても使うことができます"。

## クラス

### 基本クラス
- **BasicObject**: ほぼ何も定義されていない特殊なクラス
- **Object**: すべてのクラスのスーパークラス
- **ARGF.class**: ARGF を表すクラス

### コレクション
- **Array**: 任意のRubyオブジェクトを要素として持つ配列クラス
- **Hash**: キーと値の関連づけを行うハッシュテーブル
- **Range**: 数値、日付、文字列などの範囲を表すクラス
- **Set**: 要素間に順序関係を持たない集合クラス

### 数値関連
- **Numeric**: 数値を表す抽象クラス
  - **Integer**: 整数クラス
  - **Float**: 浮動小数点数クラス
  - **Complex**: 複素数を扱うクラス
  - **Rational**: 有理数を扱うクラス

### 文字列・パターン
- **String**: ヌル文字を含む任意のバイト列を扱う文字列クラス
- **Symbol**: 文字列と一対一に対応するシンボルクラス
- **Regexp**: スラッシュで囲んだ形式の正規表現クラス
- **MatchData**: 正規表現マッチ情報を扱うクラス

### ファイル・ディレクトリ
- **File**: ファイルアクセスのためのクラス
- **File::Stat**: ファイル情報を格納するクラス
- **Dir**: ディレクトリ操作を行うクラス
- **IO**: 基本的な入出力機能を提供するクラス

### スレッド・同期
- **Thread**: メモリ空間を共有する並行制御の流れ
- **Thread::Mutex**: 相互排他ロック機構
- **Thread::ConditionVariable**: スレッド同期の状態変数
- **Thread::Queue**: スレッド間FIFO通信路
- **Fiber**: ノンプリエンプティブな軽量スレッド

### その他
- **Binding**: ローカル変数テーブルとselfの情報保持
- **Proc**: ブロックをオブジェクト化した手続きオブジェクト
- **Method**: オブジェクト化されたメソッド
- **UnboundMethod**: レシーバを持たないメソッド
- **Enumerator**: 遅延評価や外部イテレータ機能提供
- **Time**: 時刻を表すクラス
- **Random**: MT19937擬似乱数生成器
- **Data**: 値オブジェクト定義に利用するクラス
- **Struct**: 構造体を生成するクラス
- **Module**: モジュールのクラス
- **Class**: クラスのクラス

## モジュール

- **Comparable**: 比較演算をサポートするミックスイン
- **Enumerable**: 繰り返し処理のミックスイン
- **Kernel**: すべてのクラスから参照可能なメソッド定義
- **Marshal**: オブジェクトをファイル/文字列に書き出し・読み込み
- **Math**: 浮動小数点演算をサポート
- **GC**: ガベージコレクション制御
- **ObjectSpace**: すべてのオブジェクト操作
- **Process**: UNIXプロセス管理
- **Signal**: UNIXシグナル関連操作
- **Encoding**: 文字エンコーディング処理
- **Warning**: 警告出力機能

## オブジェクト

- **ARGF**: スクリプト引数をファイル名とみなす仮想ファイル
- **ENV**: 環境変数を表すハッシュライクオブジェクト
- **main**: トップレベルのselfを表すオブジェクト

## 例外クラス階層

### 最上位
- **Exception**: すべての例外の祖先

### 主要なカテゴリ
- **StandardError**: 通常プログラムで発生する可能性の高い例外
  - ArgumentError, TypeError, NameError, NoMethodError, ZeroDivisionError等
- **SystemExit**: インタプリタ終了時の例外
- **SignalException**: 捕捉していないシグナル受信時
- **ScriptError**: スクリプト文法エラー関連
- **SecurityError**: セキュリティ問題発生時

### エンコーディング関連
EncodingError配下の互換性エラーや変換エラー各種

### スレッド関連
ThreadError, FiberError等のスレッド固有例外

### システムコール
Errno::EXXXで表現される各種システムエラー（200以上のエラーコード）
