# ライブラリ一覧 (Ruby 3.4 リファレンスマニュアル)

## 組み込み

### [組み込みライブラリ](builtin.md)

組み込みライブラリはRuby本体に統合されており、requireなしで使用可能です。

## CUI

- **expect** - IOオブジェクトから指定パターンの読み込み待機
- **io/console** - 端末入出力制御機能
- **pty** - 擬似端末処理
- **readline** - GNU Readlineコマンドラインインタフェース

## 文字コード

- **kconv** - 日本語文字コード変換
- **nkf** - nkfのRubyラッパー

## コマンドライン

- **getoptlong** - GNU getopt_long互換のオプション解析
- **optparse** - コマンドラインオプション処理

## データベース

- **dbm** - DBMサポート
- **gdbm** - GNU Database Managerサポート
- **pstore** - Rubyオブジェクトのファイル格納
- **sdbm** - SDBMサポート

## 日付・時間

- **date** - 日付処理
- **time** - Timeクラス拡張、RFC準拠の文字列変換

## デザインパターン

- **delegate** - メソッド委譲機能
- **forwardable** - 委譲機能の追加
- **observer** - Observerパターン実装
- **singleton** - Singletonパターン実装

## 開発

- **benchmark** - ベンチマーク測定
- **coverage** - カバレッジ測定
- **debug** - Rubyデバッガ
- **did_you_mean** - NameError/NoMethodError時の提案表示
- **irb** - Interactive Rubyシェル
- **minitest/mock** - モックライブラリ
- **minitest/spec** - BDD風テスト記述
- **minitest/unit** - ユニットテスト
- **mkmf** - 拡張ライブラリ用Makefile生成
- **power_assert** - Power Assert提供
- **pp** - 見やすいオブジェクト出力
- **rake** - Rakeタスク自動化ツール
- **rbconfig** - Ruby設定情報
- **test/unit** - ユニットテストフレームワーク
- **tracer** - 実行トレース出力

## ファイル

- **fileutils** - 基本的なファイル操作
- **find** - ディレクトリ探索
- **pathname** - オブジェクト指向的パス操作
- **tempfile** - テンポラリファイル操作
- **tmpdir** - テンポラリディレクトリ
- **un** - Unixコマンド代替ユーティリティ

## ファイルフォーマット

- **csv** - CSV形式処理
- **json** - JSON形式処理
- **psych** - YAMLバックエンド (libyaml基盤)
- **rdoc** - ドキュメント生成ツール
- **rexml** - Pure Ruby XMLパーサ(DOM/SAX)
- **rss** - RSS処理
- **yaml** - YAML形式処理
- **zlib** - 圧縮ライブラリ、gzip対応

## GC

- **weakref** - 弱参照実装

## 入出力

- **fcntl** - ファイルディスクリプタ制御定数
- **io/nonblock** - ノンブロックモード処理
- **io/wait** - IO読み込み可能待機
- **open3** - サブプロセス標準入出力パイプ接続

## 数学

- **bigdecimal** - 任意精度10進浮動小数点演算
- **matrix** - 行列・ベクトル処理
- **prime** - 素数・素因数分解処理
- **tsort** - トポロジカルソート実装

## ネットワーク

- **cgi** - CGIプログラム支援
- **drb** - 分散オブジェクトプログラミング
- **ipaddr** - IPアドレス処理
- **net/ftp** - FTPプロトコル
- **net/http** - HTTPプロトコル (RFC2616)
- **net/imap** - IMAPクライアント (RFC2060)
- **net/pop** - POP3メール受信
- **net/smtp** - SMTPメール送信
- **open-uri** - HTTP/FTPアクセス簡略化
- **openssl** - OpenSSL暗号化通信
- **resolv** - DNS名前解決 (thread対応)
- **socket** - ソケット通信 (プロセス間/ホスト間)
- **uri** - URI処理
- **webrick** - HTTPサーバーフレームワーク

## テキスト

- **digest** - メッセージダイジェスト
- **erb** - eRubyスクリプト処理
- **ripper** - Rubyプログラム解析
- **shellwords** - UNIXシェル単語分割・エスケープ
- **stringio** - 文字列IOインタフェース
- **strscan** - 高速文字列スキャン

## スレッド

- **monitor** - モニター同期機構
- **mutex_m** - Mutexモジュール版
- **thread** - スレッド互換性ライブラリ (2.3.0以降は組み込み)
- **timeout** - タイムアウト処理

## Unix

- **etc** - /etc情報取得
- **syslog** - syslogインターフェース

## Windows

- **win32/registry** - レジストリアクセス
- **win32/resolv** - 名前解決情報取得
- **win32ole** - COM/ActiveX処理

## その他

- **abbrev** - 文字列短縮形生成
- **base64** - Base64エンコード/デコード
- **continuation** - 継続オブジェクト処理
- **English** - 特殊変数の英語別名提供
- **fiddle** - ダイナミックリンクライブラリ処理
- **logger** - ログ記録
- **objspace** - メモリ/オブジェクト統計情報
- **ostruct** - 動的構造体
- **prettyprint** - Pretty printing実装
- **racc/parser** - Raccランタイム
- **rinda/rinda** - タプルスペース実装
- **rubygems** - RubyGems管理ライブラリ
- **securerandom** - 安全な乱数発生器
