# 環境変数 (Ruby 3.4 リファレンスマニュアル)

## 概要

Rubyインタプリタが参照する環境変数について説明します。

## 環境変数一覧

### RUBYOPT

"Rubyインタプリタにデフォルトで渡すオプションを指定します。" 無効なオプションを指定すると例外が発生します。

**例:**
```
$ RUBYOPT=-y ruby -e ""
ruby: invalid switch in RUBYOPT: -y (RuntimeError)
```

**設定方法:**

sh系:
```bash
RUBYOPT='-Ke -rkconv'
export RUBYOPT
```

csh系:
```csh
setenv RUBYOPT '-Ke -rkconv'
```

MS-DOS系:
```
set RUBYOPT=-Ke -rkconv
```

### RUBYPATH

-Sオプション指定時に、この環境変数で指定したディレクトリがRubyスクリプト探索の対象となり、PATH値よりも優先されます。

**設定方法:**

sh系:
```bash
RUBYPATH=$HOME/ruby:/opt/ruby
export RUBYPATH
```

csh系:
```csh
setenv RUBYPATH $HOME/ruby:/opt/ruby
```

MS-DOS系:
```
set RUBYPATH=%HOMEDRIVE%%HOMEPATH%\ruby;\opt\ruby
```

### RUBYLIB

"Rubyライブラリの探索パスのデフォルト値の前にこの環境変数の値を付け足します。"

**設定方法:**

sh系:
```bash
RUBYLIB=$HOME/ruby/lib:/opt/ruby/lib
export RUBYLIB
```

csh系:
```csh
setenv RUBYLIB $HOME/ruby/lib:/opt/ruby/lib
```

MS-DOS系:
```
set RUBYLIB=%HOMEDRIVE%%HOMEPATH%\ruby\lib;\opt\ruby\lib
```

### RUBYSHELL

mswin32版およびmingw32版のrubyでのみ有効です。`Kernel.#system`でコマンド実行時に使用するシェルを指定します。省略時はCOMSPECの値が使用されます。

### PATH

コマンド実行時の検索パスです。未設定時は "/usr/local/bin:/usr/ucb:/usr/bin:/bin:." が使用されます。

### RUBY_GC_*

GCチューニング用の環境変数については、GCクラスのドキュメントを参照してください。

---

**ライセンス:** [Creative Commons License](https://creativecommons.org/licenses/by/3.0/)
