# Ruby プログラムの実行

## Ruby プログラム

実行とは文の連なりを評価することです。"なんらかの形であたえられたプログラムテキストをコンパイルし、BEGIN 文があればそれを評価し、トップレベルの式の連なりを評価し、END ブロックがあれば最後にそれを評価して終了"します。

## 文

### if

条件式を評価し、真なら対応する本体を実行。偽なら `elsif` 節を順に評価し、最初に真になった節を実行。すべて偽なら `else` 節を実行します。

### while / until

ループ制御文。条件に基づいて繰り返し実行されます。

### for

### begin 〜 end

### if / unless / while / until 修飾子

## クラス定義式

```ruby
class ClassName [< スーパークラス式]
  式
end
```

クラスは実行時に生成されます。同名クラスが存在する場合は再利用されます。定数「ClassName」に代入され、その上でクラス本体が評価されます。

## モジュール定義式

```ruby
module ModuleName
  本体
end
```

実行時に無名モジュールが生成され、定数に代入されます。既存モジュール追加が可能です。

## 特異クラス定義式

```ruby
class << EXPR
  本体
end
```

オブジェクトの特異クラスを定義します。`Fixnum`、`Symbol`、`true`、`false`、`nil` には定義できません。

## メソッド定義式

```ruby
def method_name(arg, argwithdefault=expr, *restarg, &block)
  本体
end
```

実行時にメソッドが定義されます。メソッド名を `Symbol` として返します。

## 特異メソッド定義式

```ruby
def expr.method_name(arg, argwithdefault=expr, *restarg, &block)
  本体
end
```

オブジェクトの特異クラスにメソッドを定義します。

## BEGIN / END

- **BEGIN**: コンパイル時に登録（実行の最初に評価）
- **END**: コンパイル時に登録（実行の最後に評価）

## メソッド

### メソッドの呼び出し

レシーバ式を評価してオブジェクトを得ます。引数を左から右に評価し、メソッド検索を実行。ブロック付きで呼び出す場合、`yield` 時のみブロックが評価されます。

### eval

第二引数に `Proc` または `Binding` オブジェクトを与えると、その生成時のブロック上で文字列が評価されます。

## 代入

変数は何度でも代入可能。定数は1度のみ代入可能です。

### ローカル変数

単一ブロックに所属。ネストされたブロック内からアクセス可能。定義はコンパイル時に完了し、初期値は `nil` です。

### インスタンス変数

オブジェクトに所属。定義は代入で兼ね、未定義時は `nil` を返します。

### クラス変数

クラスとそのサブクラス、インスタンスに所属。未定義参照で `NameError` が発生します。

### グローバル変数

全箇所からアクセス可能。未定義参照で `nil` を返します。

### 定数

クラス/モジュールに所属。"最初の代入が定義を兼ねます"。再定義は警告のみで現在は可能ですが推奨されません。

---

*ライセンス: [Creative Commons License (CC BY 3.0)](https://creativecommons.org/licenses/by/3.0/)*
