# はじめに (Ruby 3.4 リファレンスマニュアル)

## はじめに

Rubyはインタプリタ言語で、"オブジェクト指向プログラミングのための手軽な言語"です。Perlのようなテキスト処理機能やシステム管理機能を備えています。

シンプルで理解しやすく、拡張も容易な設計となっています。

## Rubyの特長

- **インタプリタ言語** - コンパイルを必要としない
- **動的型付け** - 変数の型宣言が不要
- **変数宣言不要** - 変数名から種類を判別
- **単純な文法** - Eiffelからの影響を受けたシンプル設計
- **自動メモリ管理** - ガベージコレクタにより自動回収
- **純粋なオブジェクト指向** - すべてのデータをオブジェクトとして統一的に扱う
- **クラス・継承・メソッド** - OOP言語の基本機能を実装
- **特異メソッド** - 特定オブジェクトへのメソッド付加が可能
- **Mix-in** - モジュールによる実装共有
- **イテレータ** - ブロック付きメソッド呼び出し
- **クロージャ** - 手続きをオブジェクト化
- **強力な正規表現** - Perlをお手本とした文字列操作機能
- **多倍長整数** - メモリ許可範囲での大数演算
- **例外処理** - 例外的状況への対応機能
- **OSへの直接アクセス** - システムコール呼び出し機能
- **ダイナミックローディング** - 実行時のオブジェクトファイル読み込み

---

[Creative Commons License](https://creativecommons.org/licenses/by/3.0/)
