# 手続きオブジェクトの挙動の詳細

## 目次

- [手続きオブジェクトとは](#手続きオブジェクトとは)
- [手続きを中断して値を返す](#手続きを中断して値を返す)
- [Proc オブジェクトをブロック付きメソッド呼び出しに使う](#proc-オブジェクトをブロック付きメソッド呼び出しに使う)
- [lambda と proc と Proc.new とイテレータの違い](#lambda-と-proc-と-procnew-とイテレータの違い)
- [orphan な手続きオブジェクトの挙動](#orphan-な手続きオブジェクトの挙動)

## 手続きオブジェクトとは

手続きオブジェクトはブロックをコンテキスト（ローカル変数のスコープやスタックフレーム）とともにオブジェクト化したもので、`Proc`クラスのインスタンスとして実現されています。

ブロック内では新たなスコープが導入されつつも、外側のローカル変数を参照できます。

### 例

```ruby
var = 1
$foo = Proc.new { var }
var = 2

def foo
  $foo.call
end

p foo       # => 2
```

## 手続きを中断して値を返す

手続きオブジェクトを中断して呼出し元へ値を返すには、`next`を使用します。`break`や`return`ではありません。

### 例

```ruby
def foo
  f = Proc.new{
    next 1
    2              # この行に到達することはない
  }
end

p foo().call       #=> 1
```

## lambda と proc と Proc.new とイテレータの違い

`Kernel.#lambda`と`Proc.new`の両者は`Proc`クラスのインスタンスを生成しますが、いくつかの場面で挙動が異なります。`lambda`のほうがメソッドに近い動作をするよう設計されています。

`Kernel.#proc`は`Proc.new`と同じです。

### 引数の扱い

**lambda**はより厳密で、引数の数が違うとエラーになります。**Proc.new**は引数を多重代入に近い扱い方をします。

### ジャンプ構文の挙動の違い

#### 結果表

| | return | next | break |
|---|---|---|---|
| **Proc.new** | メソッドを抜ける | 手続きオブジェクトを抜ける | 例外が発生する |
| **proc** | メソッドを抜ける | 手続きオブジェクトを抜ける | 例外が発生する |
| **lambda** | 手続きオブジェクトを抜ける | 手続きオブジェクトを抜ける | 手続きオブジェクトを抜ける |
| **イテレータ** | メソッドを抜ける | 手続きオブジェクトを抜ける | 手続きオブジェクトを抜ける |

## orphan な手続きオブジェクトの挙動

Procを生成したメソッドから脱出した後、手続きオブジェクトからの`return`や`break`は`LocalJumpError`例外を発生させます。ただし`lambda`で生成した手続きオブジェクトはメソッドと同じように動作するため、例外は発生しません。

---

**ライセンス:** [Creative Commons License](https://creativecommons.org/licenses/by/3.0/)
