# 字句構造

## 概要

Ruby 3.4リファレンスマニュアルの字句構造セクションです。

Rubyの現在の実装はASCIIキャラクタセットを使用しており、大文字と小文字を区別します。空白文字やコメントは、識別子とリテラルの途中を除き任意の場所に配置可能です。

## 識別子

英文字またはアンダースコア（`_`）で始まり、英文字、アンダースコア、または数字で構成されます。長さに制限はありません。

**例:**
```
foobar
ruby_is_simple
```

## コメント

`#`から行末までをコメントとして扱います（文字列内の`#`を除く）。

**例:**
```
# this is a comment line
```

## 埋め込みドキュメント

`=begin`で始まる行から`=end`で始まる行までがドキュメント部分として処理されます。

**例:**
```
=begin
the everything between a line beginning with `=begin' and
that with `=end' will be skipped by the interpreter.
=end
```

## 予約語

以下の単語は予約語です：

BEGIN、class、ensure、nil、self、when、END、def、false、not、super、while、alias、defined?、for、or、then、yield、and、do、if、redo、true、__LINE__、begin、else、in、rescue、undef、__FILE__、break、elsif、module、retry、unless、__ENCODING__、case、end、next、return、until

番号指定パラメータ（`_1`～`_9`）は変数名またはメソッド名として使用できません。

---

[フィードバック](https://github.com/rurema/doctree/issues/new) | [編集](https://github.com/rurema/doctree/edit/master/refm/doc/spec/lexical.rd#L1)
