# 多言語化 (Ruby 3.4 リファレンスマニュアル)

## 多言語化

Ruby supports various character encodings beyond US-ASCII. String objects maintain their own encoding information, allowing different encodings to coexist within the same process.

### Key Features

- **Dynamic Encoding**: Internal string representation encoding is not fixed; programmers select encodings based on their needs
- **Magic Comments**: Non-ASCII characters in scripts require encoding specification via magic comments
- **Flexible Identifiers**: Variable names, method names, and class names can use non-ASCII characters (though not recommended outside string and regex literals)

---

## M17N プログラミングの基本

Programmers must consider encoding when handling strings. Objects should carry appropriate encoding information at creation. Strings are typically generated from:

1. Literals
2. I/O operations
3. String operations

Focus attention on literal and I/O sources, as Ruby typically handles string operations appropriately.

---

## エンコーディングの変更

Two primary methods modify string encoding:

- **`String#encode`**: Creates new string with converted encoding
- **`String#force_encoding`**: Destructively overwrites encoding information

```ruby
"いろは".encode("Shift_JIS")
"\xA4\xA4\xA4\xED\xA4\xCF".force_encoding("EUC-JP")
```

---

## Ruby がサポートするエンコーディング

### ASCII互換エンコーディング
UTF-8, EUC-JP, Shift_JIS receive full support

### ASCII互換ではないエンコーディング
Cannot be used as script encoding; fixed-regex matching raises exceptions (e.g., UTF-16LE, UTF-16BE)

### ダミーエンコーディング
Ruby recognizes names only, not character sequence processing (ISO-2022-JP, UTF-7)

---

## スクリプトエンコーディング

Specified via magic comments; must use ASCII-compatible encodings.

### Magic Comment Format

```ruby
# coding: euc-jp
# encoding: euc-jp
# -*- coding: euc-jp -*-
# vim:set fileencoding=euc-jp:
```

### Encoding Priority

Magic comment > `-K` > `RUBYOPT` `-K` > shebang

Default: UTF-8 for normal scripts; locale for stdin/`-e` execution

---

## リテラルのエンコーディング

String, regex, and symbol literals inherit the script encoding. Unicode escapes (`\uXXXX`) force UTF-8 encoding.

```ruby
# coding: us-ascii
p __ENCODING__      #=> #<Encoding:US-ASCII>
p "\u3042".encoding #=> #<Encoding:UTF-8>
```

---

[![Creative Commons License](https://i.creativecommons.org/l/by/3.0/88x31.png)](https://creativecommons.org/licenses/by/3.0/)
