# プログラム・文・式

## 概要

Rubyプログラムは式を並べたもので、式と式の間はセミコロン(;)または改行で区切ります。バックスラッシュに続く改行は継続行となります。

## 式

式の例：
```ruby
true
(1+2)*3
foo()
if test then ok else ng end
```

Rubyの式には以下が含まれます：

- 変数と定数
- リテラル
- 演算子式
- 制御構造（if、whileなど）
- メソッド呼び出し
- クラス／メソッド定義

式は括弧でグルーピング可能で、評価されると値が定まり、その値を返します。空の式 `()` は `nil` を返します。

### メソッド引数に指定できない式

以下の式はメソッド引数に直接指定できません：

- `and`, `or`, `not`
- `if`/`unless`/`rescue` 修飾式

括弧によるグルーピングで普通の式として使用できます。

## プログラムの終り

Rubyインタプリタが読み込みを終了するタイミング：

- ファイルの終り（evalの場合は文字列の終り）
- Ctrl+D、Ctrl+Z
- `__END__` のみの行（前後に空白があると認識されません）

---

[![Creative Commons License](https://i.creativecommons.org/l/by/3.0/88x31.png)](https://creativecommons.org/licenses/by/3.0/)
