# 正規表現 (Ruby 3.4 リファレンスマニュアル)

## 概要

正規表現は文字列のパターンを記述するための言語です。文字列が指定したパターンを含んでいるかを判定し、マッチ位置を知ることができます。

正規表現リテラルは以下の形式で記述します：

```ruby
/pat/
%r{pat}
Regexp.new("pat")
```

---

## メタ文字とエスケープ

メタ文字は正規表現内で特別な働きをします：

```
( ) [ ] { } . ? + * | \
```

これらをリテラルとして使用するには、バックスラッシュでエスケープします。

---

## 文字クラス

角括弧 `[]` で囲まれた文字のいずれかにマッチします：

```ruby
/W[aeiou]rd/  # Ward, Werd, Wird, Word, Wurd
/[a-z]/       # 範囲指定
/[^a-d]/      # 否定（a-d以外）
```

### 略記法

| 記法 | 説明 |
|------|------|
| `\w` | 単語構成文字 `[a-zA-Z0-9_]` |
| `\d` | 10進数字 `[0-9]` |
| `\s` | 空白文字 |
| `\h` | 16進数字 |

---

## 繰り返し（量指定子）

### 貪欲量指定子（最大マッチ）

```
* 0回以上
+ 1回以上
? 0回もしくは1回
{n} ちょうどn回
{n,} n回以上
{n,m} n回以上m回以下
```

### 最小量指定子

```
*? +? ?? {n,}? {n,m}?
```

---

## キャプチャ

丸括弧 `()` でマッチした部分を参照できます：

```ruby
m = /[csh](..) [csh]\1 in/.match("The cat sat in the hat")
m[1] # => "at"
```

### 名前付きキャプチャ

```ruby
m = /\$(?<dollars>\d+)\.(?<cents>\d+)/.match("$3.67")
m[:dollars] # => "3"
m[:cents]   # => "67"
```

---

## アンカー

| 記法 | 説明 |
|------|------|
| `^` | 行頭 |
| `$` | 行末 |
| `\A` | 文字列先頭 |
| `\Z` | 文字列末尾（末尾改行の手前） |
| `\z` | 文字列末尾 |
| `\b` | 単語境界 |

### 先読み・後読み

```ruby
(?=pat)   # 肯定先読み
(?!pat)   # 否定先読み
(?<=pat)  # 肯定後読み
(?<!pat)  # 否定後読み
```

---

## オプション

```ruby
/pat/i    # 大文字小文字を無視
/pat/m    # .が改行にマッチ
/pat/x    # フリーフォーマットモード
/pat/o    # #{} を1回限り展開
```

---

## 特殊変数

```ruby
$~  # 最後のMatchDataオブジェクト
$&  # マッチテキスト全体
$`  # マッチ前の文字列
$'  # マッチ後の文字列
$1, $2, ...  # キャプチャ文字列
```

---

## 参考文献

- 『正規表現技術入門』新屋良磨ら著、技術評論社（2015）
- 『詳説正規表現 第3版』Jeffrey E. F. Friedl著、オライリー・ジャパン（2008）
- [Onigmo ドキュメント](https://github.com/k-takata/Onigmo/blob/master/doc/RE.ja)
