# Rubyの起動 (Ruby 3.4 リファレンスマニュアル)

## 概要

Rubyインタプリタの起動は以下の書式で行います：

```
ruby [ option ...] [ -- ] [ programfile ] [ argument ...]
```

オプション列の終わりは `--` で明示でき、`programfile` はRubyスクリプトファイルです。省略または `-` を指定した場合は標準入力を使用します。

## 目次

- [コマンドラインオプション](#コマンドラインオプション)
- [インタプリタ行の解釈](#インタプリタ行の解釈)

---

## コマンドラインオプション

### `-0数字`
入力レコードセパレータ（`$/`）を8進数で指定します。指定しない場合はヌル文字になります。

### `-a`
`-n` または `-p` と併用してオートスプリットモードを有効にします。各ループの先頭で `$F = $_.split` が実行されます。

### `--backtrace-limit=num`
バックトレースの最大行数を指定します。

### `-C directory`
スクリプト実行前に指定ディレクトリに移動します。

### `-c`
スクリプトをコンパイルのみ実行します。文法エラーがなければ「Syntax OK」を出力します。

### `--copyright`
著作権表示を出力します。

### `-d / --debug`
デバッグモードで実行し、`$DEBUG` と `$VERBOSE` を true にセットします。

### `-E ex[:in] / --encoding ex[:in]`
デフォルトの外部および内部エンコーディングを指定します。

**使用例：**

```bash
ruby -E EUC-JP -e 'p Encoding.default_external'
```

### `--external-encoding encoding`
デフォルトの外部エンコーディングを指定します。

### `--internal-encoding encoding`
デフォルトの内部エンコーディングを指定します。

### `--enable feature`
指定した機能を有効にします：

- `gems` - rubygems（デフォルト：有効）
- `error_highlight` - エラーハイライト（デフォルト：有効）
- `did_you_mean` - did_you_mean（デフォルト：有効）
- `rubyopt` - RUBYOPT環境変数（デフォルト：有効）
- `frozen-string-literal` - 文字列リテラルをfreeze（デフォルト：無効）
- `jit` - JIT（デフォルト：無効）
- `mjit` - MJIT（デフォルト：無効）
- `yjit` - YJIT（デフォルト：無効）

### `--disable`
機能を無効にします（`--enable` の逆）。

### `-e script`
コマンドラインからスクリプトを指定します。複数指定時は改行で区切られます。

**例：**
```bash
ruby -e "5.times do |i|" -e "puts i" -e "end"
```

### `-Fregexp`
入力フィールドセパレータ（`$;`）を指定します。

### `-h / --help`
コマンドラインオプションの概要を表示します。

### `-i[extension]`
ファイルをインプレース編集し、元のファイルを拡張子付きで保存します。

**例：**
```bash
ruby -p -i.bak -e '$_.upcase!' /tmp/junk
```

### `-I directory`
ファイルロードパスを指定（`$:` 配列に追加）します。

### `-l`
行末の自動処理を行います。`$\` を `$/` と同じ値に設定し、`-n` または `-p` と併用時に `chomp!` を実行します。

### `-n`
プログラム全体を `while gets ... end` で囲むように動作します。

### `-p`
`-n` と同様ですが、各ループの最後に `$_` を出力します。

**例：**
```bash
echo matz | ruby -p -e '$_.tr! "a-z", "A-Z"'
# 出力: MATZ
```

### `-r feature`
スクリプト実行前にライブラリを `require` します。

### `-s`
スクリプト名に続く `-` で始まる引数をグローバル変数に設定します。

**例：**
```ruby
#! /usr/local/bin/ruby -s
print "true\n" if $xyz
```

### `-S`
スクリプト名が `/` で始まらない場合、PATH環境変数を使用してスクリプトを探します。

### `-v`
冗長モード。バージョンを表示し、`$VERBOSE` を true にセットします。

### `--verbose`
冗長モード。`$VERBOSE` を true にセットします。

### `--version`
Rubyバージョンを表示します。

### `-w`
バージョン表示なしで冗長モードになります。

### `-W[level] / -W:category`
警告レベルを指定します：

- `-W0` - 警告なし
- `-W1` - 重要な警告のみ（デフォルト）
- `-W2` または `-W` - すべての警告

カテゴリ指定：
- `-W:deprecated` - 非推奨機能の警告を出力
- `-W:no-deprecated` - 非推奨機能の警告を非表示（デフォルト）
- `-W:experimental` - 実験的機能の警告を出力（デフォルト）
- `-W:no-experimental` - 実験的機能の警告を非表示

### `-x[directory]`
メッセージ中のスクリプトを取り出して実行します。`#!` で始まり「ruby」を含む行までを読み飛ばします。

### `-y / --yydebug`
コンパイラデバッグモード。構文解析過程を表示します。

---

## JIT のオプション（実験的）

### `--jit`
JITを有効にします（YJITが優先）。

---

## MJIT のオプション（実験的）

### `--mjit`
デフォルト設定でMJITを有効にします。

### `--mjit-warnings`
JIT警告を出力します。

### `--mjit-debug`
JITデバッグを有効にします。

### `--mjit-wait`
毎回JITコンパイル完了まで待機（テスト用）。

### `--mjit-save-temps`
一時ファイルを保存（テスト用）。

### `--mjit-verbose=num`
ログレベル num 以下を標準エラーに出力（デフォルト：0）。

### `--mjit-max-cache=num`
キャッシュ内のJITメソッド最大数（デフォルト：10000）。

### `--mjit-min-calls=num`
JIT起動の呼び出し回数（デフォルト：10000）。

---

## YJIT のオプション（実験的）

### `--yjit`
デフォルト設定でYJITを有効にします。

### `--yjit-exec-mem-size=num`
実行可能メモリブロックサイズ（MiB、デフォルト：256）。

### `--yjit-call-threshold=num`
JIT起動呼び出し回数（デフォルト：10）。

### `--yjit-max-versions=num`
ベーシックブロックごとの最大バージョン数（デフォルト：4）。

### `--yjit-greedy-versioning`
貪欲なバージョニングモード（デフォルト：無効）。

---

## インタプリタ行の解釈

スクリプトが `#!` で始まり、その行に「ruby」を含まない場合、その行を読み飛ばします。`#!` 以下に「ruby」を含む行が見つかったら、その行以下をRubyスクリプトとして実行します。

**例：**

```bash
#!/bin/sh
exec ruby -x "$0" "$@"
#!ruby
p ARGV
puts "Hello, World!"
```

これはRubyをスペース含むパスにインストールした場合に有用です。

---

*© [Creative Commons License](https://creativecommons.org/licenses/by/3.0/)*
