# 終了処理

## 概要

Rubyスクリプトは、スクリプト終了時またはキャッチされない例外発生時に終了します。`Kernel.#exit`、`Kernel.#abort`、またはメインスレッドへの`Thread.kill`は`SystemExit`例外を生成します。

## 終了時の処理順序

終了時には以下の処理が順序通り実行されます：

1. すべてのスレッドを`Thread.kill`で終了する
2. Ruby の擬似シグナルSIGEXITのハンドラを実行する（登録されている場合）
3. ENDブロック（`END { ... }`または`Kernel.#at_exit`で指定）を逆順で実行
4. `ObjectSpace.#define_finalizer`で登録されたファイナライザを実行（順序は不定）
5. `exit(3)`により終了する

## 終了ステータス値

スクリプト終了時のステータス値は終了方法に依存します：

- スクリプト終端に到達：0
- `Kernel.#exit`の引数として渡された値
- `SystemExit`以外の例外：1

## 即座終了

`Kernel.#exit!`による終了は`_exit(2)`を実行するのみで、上述の処理は一切実行されません。

---

**ライセンス**: [Creative Commons License](https://creativecommons.org/licenses/by/3.0/)
![CC License Badge](https://i.creativecommons.org/l/by/3.0/88x31.png)
