# スレッド (Ruby 3.4 リファレンスマニュアル)

## スレッド

スレッドは「メモリ空間を共有して同時に実行される制御の流れ」であり、Ruby では Thread クラスのインスタンスで表現されます。

### 実装

ネイティブスレッドで実装されていますが、現在の Ruby VM は Giant VM lock (GVL) を備えており、同時実行ネイティブスレッドは常にひとつです。ただし IO 関連のブロッキングシステムコールでは GVL を解放し、スレッドの同時実行が可能になります。

### スケジューリング

Ruby のスレッドスケジューリングはネイティブスレッドに依存し、詳細はプラットフォーム固有です。

### メインスレッド

プログラム開始時に生成されるスレッドです。メインスレッド終了時に、全スレッドとプログラム全体が終了します。ユーザ割込み例外はメインスレッドに送られます。

### スレッドの終了

起動時に指定したブロック実行終了でスレッド終了となり、正常終了・例外終了いずれも該当します。

### 例外発生時のスレッドの振る舞い

rescue で捕捉されない例外は、通常そのスレッドのみを警告なく終了させます。ただし Thread#join で待機中のスレッドがある場合、同じ例外が再発生します。

```ruby
begin
  t = Thread.new do
    Thread.pass
    raise "unhandled exception"
  end
  t.join
rescue
  p $!  # => "unhandled exception"
end
```

以下 3 つの方法で、インタプリタ全体中断を指定可能です：

- $DEBUG を真に設定（または -d オプション使用）
- Thread.abort_on_exception でフラグ設定
- Thread#abort_on_exception で個別スレッド設定

### スレッド終了時の ensure 節の実行

ensure 節は正常終了時、Thread#kill で強制終了時のいずれでも実行されます。

### スレッドの状態

個々スレッドは以下の実行状態を持ちます：

**run（実行または実行可能状態）**
- 生成直後、Thread#run・Thread#wakeup で起こされたスレッド
- Thread#join による終了待機終了時
- 「生きている」状態

**sleep（停止状態）**
- Thread.stop・Thread#join で停止されたスレッド
- 「生きている」状態

**aborting（終了処理中）**
- Thread#kill で終了中のスレッド
- 一時的に sleep 状態になることもある
- 「生きている」状態

**dead（終了状態）**
- Thread#kill で終了したスレッド
- 参照なければ GC により削除される
- 「死んでいる」状態

### デッドロックの検出

@todo

---

[Creative Commons License](https://creativecommons.org/licenses/by/3.0/) | [フィードバック送信](https://github.com/rurema/doctree/issues/new) | [マニュアル編集](https://github.com/rurema/doctree/edit/master/refm/doc/spec/thread.rd#L1)
